//
//  TransactionSummaryViewController.swift
//  OnlineBanking
//
//  Created by Marvin Kowalewski on 25.02.23.
//

import UIKit

class TransactionSummaryViewController : UIViewController {
    
    
    @IBOutlet var informationTextLabel: UILabel!
    
    @IBOutlet var bankAccountHeaderLabel: UILabel!
    
    @IBOutlet var recipientHeaderLabel: UILabel!
    
    @IBOutlet var giroDetailsLabel: UILabel!
    
    
    
    @IBOutlet var transactionRecipientHeaderLabel: UILabel!
    @IBOutlet var transactionIBANHeaderLabel: UILabel!
    @IBOutlet var transactionAmountHeaderLabel: UILabel!
    @IBOutlet var transactionPurposeHeaderLabel: UILabel!
    
    @IBOutlet var transactionRecipientLabel: UILabel!
    @IBOutlet var transactionIBANLabel: UILabel!
    @IBOutlet var transactionAmountLabel: UILabel!
    @IBOutlet var transactionPurposeLabel: UILabel!
    
    @IBOutlet var transactionEditRecipientImageView: UIImageView!
    @IBOutlet var transactionEditIBANImageView: UIImageView!
    @IBOutlet var transactionEditAmountImageView: UIImageView!
    @IBOutlet var transactionEditPurposeImageView: UIImageView!
    
    
    @IBOutlet var transactionTimeHeaderLabel: UILabel!
    @IBOutlet var transactionTimeLabel: UILabel!
    
    @IBOutlet var verifyTransactionButton: UIButton!
    
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        UINavigationBar.appearance().titleTextAttributes = [.foregroundColor : UIColor.black,
                                                            .font : Fonts.mediumFontWithSize(size: 18)]
        
        // we reached the transaction summary view controller
        returnedFromTransactionSummaryView = true
        
        // disable potential error messages if QR Code scan was successful
        showErrorMessageQrCodeScanFailedPublic = false
        showErrorMessageWrongQRCodePublic = false
        
        
        // style labels
        informationTextLabel.font = Fonts.mediumFontWithSize(size: 17)
        bankAccountHeaderLabel.font = Fonts.heavyFontWithSize(size: 18)
        recipientHeaderLabel.font = Fonts.heavyFontWithSize(size: 18)
        
        transactionRecipientHeaderLabel.font = Fonts.mediumFontWithSize(size: 17)
        transactionIBANHeaderLabel.font = Fonts.mediumFontWithSize(size: 17)
        transactionAmountHeaderLabel.font = Fonts.mediumFontWithSize(size: 17)
        transactionPurposeHeaderLabel.font = Fonts.mediumFontWithSize(size: 17)
        
        transactionRecipientLabel.font = Fonts.mediumFontWithSize(size: 18)
        transactionIBANLabel.font = Fonts.mediumFontWithSize(size: 16)
        transactionAmountLabel.font = Fonts.mediumFontWithSize(size: 18)
        transactionPurposeLabel.font = Fonts.mediumFontWithSize(size: 16)
        
        transactionTimeHeaderLabel.font = Fonts.mediumFontWithSize(size: 17)
        transactionTimeLabel.font = Fonts.mediumFontWithSize(size: 18)
        
        // set transaction details
        transactionRecipientLabel.text = transactionRecipientPublic
        transactionIBANLabel.text = transactionIBANPublic
        transactionAmountLabel.text = transactionAmountPublic // + " €"
        
        print("##### Transaction Amount Public:" + transactionAmountPublic)
        
        if transactionPurposePublic == "" {
            transactionPurposeLabel.text = "-"
        } else {
            transactionPurposeLabel.text = transactionPurposePublic
        }
        
        
        verifyTransactionButton.titleLabel?.font = Fonts.mediumFontWithSize(size: 17)
        Utilities.styleFilledButtonAuthScreenGreenEdged(verifyTransactionButton)
        
        showGiroAccount()
        
        [transactionRecipientLabel, transactionEditRecipientImageView, transactionIBANLabel, transactionEditIBANImageView].forEach {
                    $0?.isUserInteractionEnabled = true
                    $0?.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(tapGestureTransactionRecipientAndIBAN)))
                }
        [transactionAmountLabel, transactionEditAmountImageView].forEach {
                    $0?.isUserInteractionEnabled = true
                    $0?.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(tapGestureTransactionAmount)))
                }
        [transactionPurposeLabel, transactionEditPurposeImageView].forEach {
                    $0?.isUserInteractionEnabled = true
                    $0?.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(tapGestureTransactionPurpose)))
                }

    }
    
    func showGiroAccount() {
        //giroAccountHeaderLabel.layer.cornerRadius = 10
        //giroAccountHeaderLabel.layer.masksToBounds = true
        //giroAccountHeaderLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner]
        
        
        giroDetailsLabel.layer.cornerRadius = 10
        giroDetailsLabel.layer.masksToBounds = true
        giroDetailsLabel.layer.maskedCorners = [.layerMinXMinYCorner, .layerMaxXMinYCorner, .layerMinXMaxYCorner, .layerMaxXMaxYCorner]
        giroDetailsLabel.layer.borderWidth = 2.0
        giroDetailsLabel.layer.borderColor = UIColor.init(red: 30/255, green: 91/255, blue: 158/255, alpha: 1).cgColor
        
        giroDetailsLabel.numberOfLines = 0
        giroDetailsLabel.lineBreakMode = .byTruncatingTail
        
        giroDetailsLabel.font = Fonts.mediumFontWithSize(size: 16)
        
        let giroDetails = NSMutableAttributedString.init(string: "   LightBanking Giro Premium\n   DE12 2707 0369 1128 5096 19")
        
        giroDetails.setAttributes([NSAttributedString.Key.font: Fonts.mediumFontWithSize(size: 16),
                                    NSAttributedString.Key.foregroundColor: UIColor.darkGray],
                                   range: NSMakeRange(0, 28)) // 25
        
        giroDetailsLabel.attributedText = giroDetails

    }
    
    @IBAction func backButton(_ sender: Any) {
        let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionPurposeNC") as! UINavigationController
        
        nc.modalPresentationStyle = .fullScreen
        nc.modalTransitionStyle = .crossDissolve
        present(nc, animated: true)
    }
    
    @IBAction func closeButton(_ sender: Any) {
        let refreshAlert = UIAlertController(title: nil, message: nil, preferredStyle: UIAlertController.Style.alert)
            
        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.alignment = .left

        let message = "Sind Sie sicher, dass Sie die Überweisung abbrechen wollen?\nAlle bisher eingegebenen Daten gehen verloren."
        let attributedMessage = NSAttributedString(string: message, attributes: [NSAttributedString.Key.paragraphStyle: paragraphStyle])
        
        refreshAlert.setValue(attributedMessage, forKey: "attributedMessage")

        
        refreshAlert.addAction(UIAlertAction(title: "Überweisung fortsetzen", style: .cancel, handler: { (action: UIAlertAction!) in
              print("Handle Cancel Logic here")
            
        }))
        if let continueAction = refreshAlert.actions.first(where: { $0.title == "Überweisung fortsetzen" }) {
            continueAction.setValue(UIColor(red: 49.0/255.0, green: 84.0/255.0, blue: 143.0/255.0, alpha: 1.0), forKey: "titleTextColor")
        }
        
        refreshAlert.addAction(UIAlertAction(title: "Abbrechen", style: .default, handler: { (action: UIAlertAction!) in
              print("Handle Ok logic here")
            
            // reset all transaction fields and set var to false
            backFromBackButtonOrSummaryViewController = false
            returnedFromTransactionSummaryView = false
            transactionRecipientPublic = ""
            transactionIBANPublic = ""
            transactionAmountPublic = ""
            transactionPurposePublic = ""
            
            let tabBarController = self.storyboard?.instantiateViewController(withIdentifier: "OnlineBankingTBC") as! UITabBarController
            
            tabBarController.modalPresentationStyle = .fullScreen
            tabBarController.modalTransitionStyle = .crossDissolve
            self.present(tabBarController, animated: true)
            
            // https://www.youtube.com/watch?v=43LpNQtUvV4
            let indexData: [String: Int] = ["index" : 1]
            NotificationCenter.default.post(name: Notification.Name("changeIndex"), object: nil, userInfo: indexData)
            
        }))
        if let cancelAction = refreshAlert.actions.first(where: { $0.title == "Abbrechen" }) {
            cancelAction.setValue(Colors.greyColor, forKey: "titleTextColor")
        }



        present(refreshAlert, animated: true, completion: nil)
       
    }
    
    @objc func tapGestureTransactionRecipientAndIBAN(_ gesture: UITapGestureRecognizer) {
            guard let label = gesture.view else { return } // "gesture.view as? UILabel"
            switch label {
            case transactionRecipientLabel:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionRecipientNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            case transactionEditRecipientImageView:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionRecipientNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            case transactionIBANLabel:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionRecipientNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            case transactionEditIBANImageView:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionRecipientNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            default: break
            }
        }
    @objc func tapGestureTransactionAmount(_ gesture: UITapGestureRecognizer) {
            guard let label = gesture.view else { return } // "gesture.view as? UILabel"
            switch label {
            case transactionAmountLabel:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionAmountNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            case transactionEditAmountImageView:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionAmountNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            default: break
            }
        }
    @objc func tapGestureTransactionPurpose(_ gesture: UITapGestureRecognizer) {
            guard let label = gesture.view else { return } // "gesture.view as? UILabel"
            switch label {
            case transactionPurposeLabel:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionPurposeNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            case transactionEditPurposeImageView:
                let nc = self.storyboard?.instantiateViewController(withIdentifier: "TransactionPurposeNC") as! UINavigationController
                
                nc.modalPresentationStyle = .fullScreen
                nc.modalTransitionStyle = .coverVertical
                
                present(nc, animated: true)
            default: break
            }
        }
    
    
    @IBAction func verifyTransactionButton(_ sender: Any) {
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
                let vc = storyboard.instantiateViewController(withIdentifier: "ConfirmTransactionNC")
        vc.modalPresentationStyle = .custom
        vc.transitioningDelegate = self
        self.present(vc, animated: true, completion: nil)
    }
    
    
    
}

// MARK: - UIViewControllerTransitioningDelegate
extension TransactionSummaryViewController: UIViewControllerTransitioningDelegate {
    
    func presentationController(forPresented presented: UIViewController, presenting: UIViewController?, source: UIViewController) -> UIPresentationController? {
        ConfirmTransactionPresentationController(presentedViewController: presented, presenting: presenting)
    }
}
